/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**********************************************************!*\
  !*** ./resources/js/design_1/parts/instructor_finder.js ***!
  \**********************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  function makeUserMarker(user) {
    var userMarker = L.divIcon({
      html: "<div class='marker-pin rounded-circle'><img src='" + user.avatar + "' class='img-cover rounded-circle' alt='" + user.full_name + "'/></div>",
      iconAnchor: [24, 48],
      iconSize: [48, 48],
      className: 'rounded-circle bg-white border-0'
    });
    var marker = L.marker([user.location[0], user.location[1]], {
      icon: userMarker
    });
    marker.bindPopup(handleUserMapCardHtml(user), {
      className: 'map-instructor-card-popup'
    });
    return marker;
  }
  function handleUserRateHtml(rate) {
    var i = 5;
    var html = "<div class=\"stars-card d-flex align-items-center p-8 mt-8 rounded-16 bg-gray-100\">";
    while (--i >= 5 - rate) {
      html += "<span class=\"stars-card__item active\">".concat(starIcon, "</span>");
    }
    while (i-- >= 0) {
      html += "<span class=\"stars-card__item \">".concat(starIcon, "</span>");
    }
    html += "<span class=\"ml-4 font-14 text-gray-500\">(".concat(rate, ")</span>");
    html += "</div>";
    return html;
  }
  function handleUserMapCardHtml(user) {
    var _user$avatar, _user$full_name, _user$full_name2, _user$price;
    return "<div class=\"instructor-finder-map-popup position-relative bg-white p-16 rounded-16\">\n            <div class=\"instructor-finder-map-popup__mask\"></div>\n\n            <div class=\"position-relative d-flex-center flex-column z-index-2\">\n                <div class=\"instructor-finder-map-popup__user-avatar size-64 rounded-circle mt-16\">\n                    <img src=\"".concat((_user$avatar = user.avatar) !== null && _user$avatar !== void 0 ? _user$avatar : '', "\" class=\"img-cover rounded-circle\" alt=\"").concat((_user$full_name = user.full_name) !== null && _user$full_name !== void 0 ? _user$full_name : '', "\">\n                </div>\n\n                <h4 class=\"font-14 font-weight-bold mt-12\">").concat((_user$full_name2 = user.full_name) !== null && _user$full_name2 !== void 0 ? _user$full_name2 : '', "</h4>\n\n                ").concat(handleUserRateHtml(user.rate), "\n\n                ").concat(user.price ? "\n                        <div class=\"d-flex align-items-center mt-16\">\n                            <span class=\"text-primary font-14 font-weight-bold\">".concat(currency).concat((_user$price = user.price) !== null && _user$price !== void 0 ? _user$price : '', "</span>\n                            <span class=\"font-12 text-gray-500 ml-4\">/").concat(hourLang, "</span>\n                        </div>\n                        ") : "\n                        <div class=\"d-flex align-items-center mt-16\">\n                            <span class=\"text-primary font-14 font-weight-bold\">".concat(freeLang, "</span>\n                        </div>\n                        "), "\n\n\n                <div class=\"d-flex align-items-center gap-12 mt-16\">\n                    <a href=\"").concat(user.profileUrl, "\" class=\"d-flex-center size-36 rounded-circle bg-gray-200\" target=\"_blank\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"").concat(profileLang, "\">").concat(frameIcon, "</a>\n\n                    <a href=\"").concat(user.profileUrl, "?tab=appointments\" class=\"d-flex-center size-36 rounded-circle bg-primary\" target=\"_blank\" data-toggle=\"tooltip\" data-placement=\"top\" title=\"").concat(bookAMeetingLang, "\">").concat(calendarIcon, "</a>\n                </div>\n            </div>\n        </div>");
  }
  $(document).ready(function () {
    var instructorFinderPageMap = makeMapContainer("instructorFinderPageMap");
    if (mapUsers && Array.isArray(mapUsers)) {
      var myMarkersGroup = L.markerClusterGroup({
        showCoverageOnHover: false
      });
      var _iterator = _createForOfIteratorHelper(mapUsers),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var mapUser = _step.value;
          var marker = makeUserMarker(mapUser);
          myMarkersGroup.addLayer(marker);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      instructorFinderPageMap.addLayer(myMarkersGroup);
    }
    handleDoubleRange($('#priceRange'), 'price', function (range, minTimeEl, maxTimeEl) {
      range.onValueUpdate(function (values) {
        minTimeEl.val(values.minValue);
        maxTimeEl.val(values.maxValue);
        $('.js-filters-min-price').val(jsCurrentCurrency + values.minValue);
        $('.js-filters-max-price').val(jsCurrentCurrency + values.maxValue);
      });
    });
    handleDoubleRange($('#timeRange'), 'time', function (range, minTimeEl, maxTimeEl) {
      range.onValueUpdate(function (values) {
        minTimeEl.val(values.minValue);
        maxTimeEl.val(values.maxValue);
        $('.js-filters-min-time').val(values.minValue);
        $('.js-filters-max-time').val(values.maxValue);
      });
    });
  });
  function handleNotResultHtml() {
    return "<div class=\"no-result default-no-result mt-56 d-flex align-items-center justify-content-center flex-column\">\n                    <div class=\"no-result-logo\">\n                        <img src=\"/assets/default/img/no-results/support.png\" alt=\"\">\n                    </div>\n\n                    <div class=\"d-flex align-items-center flex-column mt-16 text-center\">\n                        <h2 class=\"font-16 font-weight-bold\">".concat(noResultTitle, "</h2>\n\n                        <p class=\"mt-4 font-12 text-center text-gray-500\">").concat(noResultHint, "</p>\n                    </div>\n                </div>");
  }

  // Load More And filters
  var loadMoreInstructors = {
    page: 1,
    has_more: true
  };
  function getInstructors(url, page, isLoadMore) {
    var $form = $('#filtersForm');
    var data = $form.serializeObject();
    data['page'] = page;
    var $loadMoreInstructors = $('#loadMoreInstructors');
    var $instructorsList = $('#instructorsList');
    $.get(url, data, function (result) {
      if (result) {
        if (isLoadMore) {
          $instructorsList.append(result.html);
        } else {
          if (result.html) {
            $instructorsList.html(result.html);
          } else {
            $instructorsList.html(handleNotResultHtml());
          }
        }
        var hasMore = page < result.last_page;
        loadMoreInstructors = {
          page: page,
          has_more: hasMore
        };
        if (!hasMore) {
          $loadMoreInstructors.addClass('d-none');
        } else {
          $loadMoreInstructors.removeClass('d-none');
        }
      }
      $loadMoreInstructors.removeClass('loadingbar').prop('disabled', false);
    }).fail(function (err) {
      $loadMoreInstructors.removeClass('loadingbar').prop('disabled', false);
    });
  }
  $('body').on('click', '#loadMoreInstructors', function (e) {
    e.preventDefault();
    var $this = $(this);
    var url = $this.attr('data-url');
    $this.addClass('loadingbar').prop('disabled', true);
    if (loadMoreInstructors.has_more) {
      getInstructors(url, loadMoreInstructors.page + 1, true);
    }
  });
  var requestTimeOut;
  $('body').on('change', '#filtersForm input, #filtersForm select', function (e) {
    e.preventDefault();
    if (requestTimeOut !== undefined) {
      clearTimeout(requestTimeOut);
    }
    var $instructorsList = $('#instructorsList');
    var $form = $('#filtersForm');
    var url = $form.attr('action');
    $('html, body').animate({
      scrollTop: $instructorsList.offset().top - 100
    }, 1000);
    $instructorsList.html("<div class=\"d-flex align-items-center justify-content-center w-100 my-56\">\n                            <img src=\"/assets/design_1/img/loading.svg\" width=\"80px\" height=\"80px\">\n                        </div>");
    loadMoreInstructors = {
      page: 1,
      has_more: true
    };
    getInstructors(url, 1, false);
  });
})(jQuery);
/******/ })()
;